 ; Ŀ
 ;   Find a file or files with the same name and a different extension.    
 ;   Copyright 1991, 2004 by Rocket Software Ltd.                          
 ;   * Note that this only searches the Acad search path.                  
 ;   Also contains utilities Mef and Fest.                                 
 ; 

 ; Ŀ
 ;   Fest - a strange Utility - write all combinations of three letters    
 ;   to a file.                                                            
 ; 
 (DEFUN C:FEST ()
  (setq chra "A")
  (setq len 1)
  (setq fn (open "c:/aaa" "w"))
  (while (< len 4)
         (write-line chra fn)
         (setq chra (alph chra))
         (setq len (strlen chra)))
  (close fn)
 (princ))

 ; Ŀ
 ;   Subroutine Alph - increment a character string.                       
 ;   Takes one argument, a string.  Returns the incremented version.       
 ; 
 (DEFUN ALPH (cname / pos char base cnamp)
  (setq cname (strcase cname))
  (setq pos (strlen cname))
  (while (and (>= pos 1)
              (setq char (substr cname pos 1))
              (<= 90 (ascii char)))
         (setq pos (1- pos)))
 ; Ŀ
 ;   If no non-z characters were found, set all to A and add an A to the   
 ;   left end of the string.                                               
 ; 
  (cond ((= pos 0)
         (setq base "")
         (repeat (1+ (strlen cname))
                 (setq base (strcat base "A")))
         (setq cname base))
 ; Ŀ
 ;   If a non-Z was found, everything to the right of it becomes an A,     
 ;   and it is incremented.                                                
 ; 
        (T (setq cnamp cname)
           (setq cname (strcat (substr cname 1 (1- pos))
                               (chr (1+ (ascii (substr cname pos 1))))))
           (setq base "")
           (repeat (strlen (substr cnamp (1+ pos)))
                   (setq base (strcat base "A")))
           (setq cname (strcat cname base))))
 cname)
 ; Ŀ
 ;   Subroutine Alph end.                                                  
 ; 

 ; Ŀ
 ;   Subroutine Findx - Find using extensions from a list.                 
 ;   Prints the names of files which were found,                           
 ;   returns T if there were any, nil otherwise.                           
 ; 
 (DEFUN FINDX (ff / tt fn typ ll ch)
  (setq len (strlen ff))
  (setq ll 1)
  (while (<= ll len)
         (if (= (substr ff ll 1) ".")
             (progn
                  (setq ff (substr ff 1 (1- ll)))
                  (setq ll len))
             (setq ll (1+ ll))))
  (setq typ (list ".arc" ".bat" ".bak" ".cfg" ".cnf" ".com" ".dat"
                  ".db"  ".dba" ".ddl" ".dll" ".doc" ".dwg" ".err"
                  ".exe" ".exp" ".fon" ".hdx" ".hlp" ".lin" ".lnk"
                  ".lsp" ".mid" ".mnu" ".mnx" ".old" ".pat" ".pgp"
                  ".plt" ".scr" ".shx" ".slb" ".tnt" ".ttf" ".txt" 
                  ".zac" ".zip"))
  (setq ll 0)
  (while (nth ll typ)
         (setq fn (strcat ff (nth ll typ)))
         (setq fn (findfile fn))
         (if fn (progn (print fn) (setq ch t)))
         (setq ll (1+ ll)))
 ch)
 ; Ŀ
 ;   Subroutine Findx end.                                                 
 ; 

 ; Ŀ
 ;   Subroutine Mfind - find a file with any (three letter)p extension.    
 ;   Arguments: Ff, the base file name.                                    
 ;              Elen, the maximum extension length.                        
 ;   Calls Alph, prints file names as they are found.                      
 ;   Returns T if any files were foud, else nil.                           
 ;   Not blindingly fast.                                                  
 ; 
 (DEFUN MFIND (ff elen / len fn chra ch)
  (setq chra "A")
  (setq len 1)
  (while (<= len elen)
         (setq fn (strcat ff "." chra))
         (if (setq fn (findfile fn))
             (progn
                  (setq ch t)
                  (print fn)))
         (setq chra (alph chra))
         (setq len (strlen chra)))
 ch)
 ; Ŀ
 ;   Subroutine Mfind end.                                                 
 ; 

 ; Ŀ
 ;   Mef - direct MegaFind.                                                
 ; 
 (DEFUN C:MEF (/ tt fn typ ll)
  (if (= (type ff) 'str)
      (setq tt (strcat "Filename <" ff ">: "))
      (setq tt "Filename: "))
  (setq fn (getstring T tt))
  (if (/= fn "") (setq ff fn))
  (if (null (mfind ff 3)) (write-line "\nNothing found."))
 (princ))

 ; Ŀ
 ;   Ffind.                                                                
 ; 
 (DEFUN C:FFIND (/ tt fn ch insp)
  (if (= (type ff) 'str)
      (setq tt (strcat "Filename <" ff ">: "))
      (setq tt "Filename: "))
  (setq fn (getstring T tt))
  (setq ch ())
  (if (/= fn "") (setq ff fn))
  (if (setq fn (findfile ff))
      (print fn)
      (progn
           (write-line (strcat "Can't find " ff
                               " - searching for similar files:"))
           (if (null (setq ch (findx ff)))
               (progn
                    (initget 0 "Yes No")
                    (Setq insp (getkword
                                  "Nothing found.  Engage Megafind? Y/<N>: "))
                    (if (= insp "Yes")
                        (if (null (mfind ff 3))
                            (write-line "\nNothing found.")))))))
 (princ))